/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Senet {
    private JFrame frmTest;
    private int des = 0;
    private int joueur = 0;
    private int[] remains = new int[2];
    private String[] players = new String[2];
    private int[] plateau = new int[30];
    private JLabel lblJoueurQuiJoue;
    private JButton btnJetDes;
    private JButton[] buttons = new JButton[30];
    private ImageIcon[] icones;
    private JCheckBox hints;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Senet window = new Senet();
                    window.frmTest.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Senet() {
        this.players[0] = "Blancs";
        this.players[1] = "Noirs";
        this.createImageIcons();
        this.initialize();
        this.reset();
    }

    private void createImageIcons() {
        String[] names = new String[]{"pion_blanc.png", "pion_noir.png", "ankh.png", "mer.png", "un.png", "deux.png", "trois.png", "mirror.png"};
        this.icones = new ImageIcon[names.length];
        int i = 0;
        while (i < names.length) {
            URL imgURL = this.getClass().getResource(names[i]);
            if (imgURL != null) {
                this.icones[i] = new ImageIcon(imgURL);
            } else {
                this.icones[i] = null;
                JOptionPane.showMessageDialog(null, "Couldn't find file: " + names[i], "Error", 0);
            }
            ++i;
        }
    }

    private void initialize() {
        this.frmTest = new JFrame();
        this.frmTest.setTitle("Senet");
        this.frmTest.setSize(560, 255);
        this.frmTest.setIconImage(this.icones[2].getImage());
        this.frmTest.setDefaultCloseOperation(3);
        this.frmTest.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.frmTest.getContentPane().add((Component)panel, "Center");
        panel.setLayout(new GridLayout(3, 10, 0, 0));
        this.buttons[0] = new JButton();
        this.buttons[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(0);
            }
        });
        panel.add(this.buttons[0]);
        this.buttons[1] = new JButton();
        this.buttons[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(1);
            }
        });
        panel.add(this.buttons[1]);
        this.buttons[2] = new JButton();
        this.buttons[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(2);
            }
        });
        panel.add(this.buttons[2]);
        this.buttons[3] = new JButton();
        this.buttons[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(3);
            }
        });
        panel.add(this.buttons[3]);
        this.buttons[4] = new JButton();
        this.buttons[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(4);
            }
        });
        panel.add(this.buttons[4]);
        this.buttons[5] = new JButton();
        this.buttons[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(5);
            }
        });
        panel.add(this.buttons[5]);
        this.buttons[6] = new JButton();
        this.buttons[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(6);
            }
        });
        panel.add(this.buttons[6]);
        this.buttons[7] = new JButton();
        this.buttons[7].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(7);
            }
        });
        panel.add(this.buttons[7]);
        this.buttons[8] = new JButton();
        this.buttons[8].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(8);
            }
        });
        panel.add(this.buttons[8]);
        this.buttons[9] = new JButton();
        this.buttons[9].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(9);
            }
        });
        panel.add(this.buttons[9]);
        this.buttons[19] = new JButton();
        this.buttons[19].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(19);
            }
        });
        panel.add(this.buttons[19]);
        this.buttons[18] = new JButton();
        this.buttons[18].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(18);
            }
        });
        panel.add(this.buttons[18]);
        this.buttons[17] = new JButton();
        this.buttons[17].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(17);
            }
        });
        panel.add(this.buttons[17]);
        this.buttons[16] = new JButton();
        this.buttons[16].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(16);
            }
        });
        panel.add(this.buttons[16]);
        this.buttons[15] = new JButton();
        this.buttons[15].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(15);
            }
        });
        panel.add(this.buttons[15]);
        this.buttons[14] = new JButton(this.icones[2]);
        this.buttons[14].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(14);
            }
        });
        panel.add(this.buttons[14]);
        this.buttons[13] = new JButton();
        this.buttons[13].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(13);
            }
        });
        panel.add(this.buttons[13]);
        this.buttons[12] = new JButton();
        this.buttons[12].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(12);
            }
        });
        panel.add(this.buttons[12]);
        this.buttons[11] = new JButton();
        this.buttons[11].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(11);
            }
        });
        panel.add(this.buttons[11]);
        this.buttons[10] = new JButton();
        this.buttons[10].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(10);
            }
        });
        panel.add(this.buttons[10]);
        this.buttons[20] = new JButton();
        this.buttons[20].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(20);
            }
        });
        panel.add(this.buttons[20]);
        this.buttons[21] = new JButton();
        this.buttons[21].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(21);
            }
        });
        panel.add(this.buttons[21]);
        this.buttons[22] = new JButton();
        this.buttons[22].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(22);
            }
        });
        panel.add(this.buttons[22]);
        this.buttons[23] = new JButton();
        this.buttons[23].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(23);
            }
        });
        panel.add(this.buttons[23]);
        this.buttons[24] = new JButton();
        this.buttons[24].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(24);
            }
        });
        panel.add(this.buttons[24]);
        this.buttons[25] = new JButton(this.icones[7]);
        this.buttons[25].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(25);
            }
        });
        panel.add(this.buttons[25]);
        this.buttons[26] = new JButton(this.icones[3]);
        this.buttons[26].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(26);
            }
        });
        panel.add(this.buttons[26]);
        this.buttons[27] = new JButton(this.icones[6]);
        this.buttons[27].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(27);
            }
        });
        panel.add(this.buttons[27]);
        this.buttons[28] = new JButton(this.icones[5]);
        this.buttons[28].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(28);
            }
        });
        panel.add(this.buttons[28]);
        this.buttons[29] = new JButton(this.icones[4]);
        this.buttons[29].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.joueCase(29);
            }
        });
        panel.add(this.buttons[29]);
        JPanel panel_1 = new JPanel();
        this.frmTest.getContentPane().add((Component)panel_1, "South");
        panel_1.setLayout(new FlowLayout(1, 5, 5));
        this.btnJetDes = new JButton("Jetter les b\u00e2tons");
        this.btnJetDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Senet.this.rollDice();
            }
        });
        this.lblJoueurQuiJoue = new JLabel("Joueur qui joue");
        panel_1.add(this.lblJoueurQuiJoue);
        panel_1.add(this.btnJetDes);
        JMenuBar menuBar = new JMenuBar();
        this.frmTest.setJMenuBar(menuBar);
        JMenu mnFichier = new JMenu("Jeu");
        menuBar.add(mnFichier);
        JMenuItem mntmNouveau = new JMenuItem("Nouveau");
        mntmNouveau.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Senet.this.reset();
            }
        });
        mnFichier.add(mntmNouveau);
        JMenuItem mntmQuitter = new JMenuItem("Quitter");
        mntmQuitter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Senet.this.frmTest.dispose();
            }
        });
        JMenu mnNommerLesJoueurs = new JMenu("Nommer les joueurs");
        mnFichier.add(mnNommerLesJoueurs);
        JMenuItem mntmJoueur = new JMenuItem("Joueur blanc");
        mntmJoueur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String name = (String)JOptionPane.showInputDialog(Senet.this.frmTest, "Nom du joueur blanc", "Changement de nom", 3, null, null, Senet.this.players[0]);
                if (name != null && !name.isEmpty()) {
                    ((Senet)Senet.this).players[0] = name;
                    if (Senet.this.joueur == 1) {
                        Senet.this.lblJoueurQuiJoue.setText(name);
                    }
                }
            }
        });
        mnNommerLesJoueurs.add(mntmJoueur);
        JMenuItem mntmJoueur_1 = new JMenuItem("Joueur noir");
        mntmJoueur_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String name = (String)JOptionPane.showInputDialog(Senet.this.frmTest, "Nom du joueur noir", "Changement de nom", 3, null, null, Senet.this.players[1]);
                if (name != null && !name.isEmpty()) {
                    ((Senet)Senet.this).players[1] = name;
                    if (Senet.this.joueur == -1) {
                        Senet.this.lblJoueurQuiJoue.setText(name);
                    }
                }
            }
        });
        mnNommerLesJoueurs.add(mntmJoueur_1);
        mnFichier.add(mntmQuitter);
        JMenu mnAide = new JMenu("Aide");
        menuBar.add(mnAide);
        this.hints = new JCheckBox("Indiquer les d\u00e9placements possibles");
        this.hints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Senet.this.plateau[26] == Senet.this.joueur) {
                    Senet.this.buttons[26].setBackground(Senet.this.hints.isSelected() ? Color.green : Color.yellow);
                }
                if (Senet.this.des != 0) {
                    if (Senet.this.des > 0) {
                        Senet.this.checkForward();
                    } else {
                        Senet.this.checkBackward();
                    }
                }
            }
        });
        mnAide.add(this.hints);
        JMenuItem mntmRgles = new JMenuItem("R\u00e8gles du jeu");
        mntmRgles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Senet.this.frmTest, "Senet est un jeu qui remonte \u00e0 l\u2019\u00c9gypte antique dont le principe est de d\u00e9placer\ndes pions le long du plateau de jeu jusqu\u2019\u00e0 les faire sortir de ce plateau. Chaque\njoueur commence avec 5 pions de sa couleur.\n\nLors de son tour, un joueur fait un jet pour d\u00e9terminer une distance de\nd\u00e9placement puis bouge un de ses pions en fonction. Historiquement, on jettait\n4 b\u00e2tons \u00e0 deux faces, une face claire marquait un point et une face fonc\u00e9e n\u2019en\nmarquait pas. Un jet de z\u00e9ro permet de d\u00e9placer un pion de cinq cases. Les\nd\u00e9placements de 1, 4 ou 5 cases permet de jouer un tour suppl\u00e9mentaire.\n\nLes restrictions sur les d\u00e9placements sont :\n \u2014 un pion doit \u00eatre boug\u00e9 exactement du nombre de cases indiqu\u00e9es par le jet ;\n \u2014 un pion ne peut pas \u00eatre d\u00e9plac\u00e9 s\u2019il devait arriver sur un pion de la m\u00eame\n    couleur ;\n \u2014 un pion qui arrive sur un pion de la couleur oppos\u00e9e \u00e9change sa place avec\n    celui-ci ;\n \u2014 deux pions ou plus de la m\u00eame couleur c\u00f4te \u00e0 c\u00f4te se prot\u00e8gent mutuellement\n    et interdisent un d\u00e9placement selon la r\u00e8gle pr\u00e9c\u00e9dente ;\n \u2014 si aucun d\u00e9placement vers l\u2019avant n\u2019est possible, le d\u00e9placement doit se faire\n    vers l\u2019arri\u00e8re ; si aucun d\u00e9placement n\u2019est possible, le tour est perdu ;\n \u2014 les pions sur les 4 derni\u00e8res cases ne sont plus prot\u00e9g\u00e9s et ne participent\n    plus \u00e0 une protection ;\n \u2014 un pion doit s\u2019arr\u00eater exactement sur la case num\u00e9ro 26 (maison de la Beaut\u00e9)\n    avant de pouvoir continuer plus loin ;\n \u2014 un pion sur la case 26 (maison de la Beaut\u00e9) peut sortir du plateau sur un jet\n    de 5 ou avancer sur un jet plus faible ; s\u2019il tombe sur une case contenant un\n    pion adverse, ce dernier se retrouve sur la case 27 si elle est vide (sinon\n    les positions sont \u00e9chang\u00e9es) ;\n \u2014 un pion sur la case 27 (maison des Eaux) se noie et fait perdre le tour\n    suppl\u00e9mentaire quand il arrive sur la case ; si un joueur commence son tour\n    de jeu avec un pion sur la case 27, il peut choisir de le placer sur la case 15\n    (maison de la r\u00e9surection) ou de faire un jet ; si le jet est 4, le pion sort du\n    plateau de jeu, sinon le tour est perdu ;\n \u2014 un pion sur les cases 28 (maison des trois juges), 29 (maison des deux juges)\n    et 30 (maison d\u2019Horus) ne peuvent ni avancer, ni reculer, mais peuvent sortir\n    du plateau sur un jet de, respectivement, 3, 2 ou n\u2019importe.", "Senet : R\u00e8gles du jeu", -1);
            }
        });
        mnAide.add(mntmRgles);
        JMenuItem mnPropos = new JMenuItem("\u00c0 Propos");
        mnPropos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Senet.this.frmTest, "Senet\nVersion 1.0\n\nMathias Ettinger", "\u00c0 Propos", 1);
            }
        });
        menuBar.add(mnPropos);
    }

    public void reset() {
        this.joueur = -1;
        this.remains[0] = 5;
        this.remains[1] = 5;
        this.des = 0;
        int i = 10;
        while (i < 30) {
            this.plateau[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.plateau[2 * i] = 1;
            this.plateau[2 * i + 1] = -1;
            ++i;
        }
        this.changeJoueur();
    }

    public boolean changeJoueur() {
        int numJoueur = (this.joueur - 1) / -2;
        if (this.remains[numJoueur] == 0) {
            JOptionPane.showMessageDialog(this.frmTest, String.valueOf(this.players[numJoueur]) + " a gagn\u00e9 !", "Fin de partie", 1);
            this.reset();
            return false;
        }
        this.joueur = -this.joueur;
        boolean shouldPlayAgain = this.des == 1 || this.des == 4 || this.des == 5;
        this.des = 0;
        this.btnJetDes.setText("Pas de jet");
        this.lblJoueurQuiJoue.setText(this.players[1 - numJoueur]);
        int i = 0;
        while (i < 30) {
            this.buttons[i].setBackground(i % 2 == 0 ? Color.yellow : Color.orange);
            if (i != 14 && i < 25) {
                this.buttons[i].setIcon(this.plateau[i] == 0 ? null : (this.plateau[i] == 1 ? this.icones[0] : this.icones[1]));
            }
            ++i;
        }
        this.setSpecialIcon(14, 2);
        this.setSpecialIcon(26, 3);
        this.setSpecialIcon(27, 6);
        this.setSpecialIcon(28, 5);
        this.setSpecialIcon(29, 4);
        this.setSpecialIcon(25, 7);
        if (this.plateau[26] == this.joueur) {
            this.buttons[26].setBackground(this.hints.isSelected() ? Color.green : Color.yellow);
        }
        return shouldPlayAgain;
    }

    private void setSpecialIcon(int numCase, int numIcon) {
        if (this.plateau[numCase] != 0) {
            this.buttons[numCase].setIcon(new CompoundIcon(CompoundIcon.Axis.Z_AXIS, this.icones[numIcon], this.icones[(this.plateau[numCase] - 1) / -2]));
        } else {
            this.buttons[numCase].setIcon(this.icones[numIcon]);
        }
    }

    public void rollDice() {
        if (this.des == 0) {
            int i = 0;
            while (i < 4) {
                if (Math.random() > 0.5) {
                    ++this.des;
                }
                ++i;
            }
            if (this.des == 0) {
                this.des = 5;
            }
            this.btnJetDes.setText("Jet :   " + this.des);
            if (this.plateau[26] == this.joueur && this.des != 4) {
                JOptionPane.showMessageDialog(this.frmTest, "Un pion est dans la maison des Eaux et ne peut \u00eatre sauv\u00e9. Le tour est perdu.");
                this.changeJoueur();
            } else if (!this.checkForward()) {
                this.des = -this.des;
                if (this.checkBackward()) {
                    JOptionPane.showMessageDialog(this.frmTest, "Pas d\u2019avanc\u00e9e possible, choisissez un pion \u00e0 reculer");
                } else {
                    JOptionPane.showMessageDialog(this.frmTest, "Aucun mouvement possible, le tour est perdu");
                    this.changeJoueur();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.frmTest, "Un seul lancer par tour", "Faute de jeu", 0);
        }
    }

    public void joueCase(int numCase) {
        if (this.des == 0) {
            if (numCase == 26 && this.plateau[numCase] == this.joueur) {
                this.plateau[numCase] = 0;
                int result = 14;
                while (this.plateau[result] != 0) {
                    --result;
                }
                this.plateau[result] = this.joueur;
                this.changeJoueur();
            } else {
                JOptionPane.showMessageDialog(this.frmTest, "Vous devez d\u2019abord faire un jet", "Faute de jeu", 0);
            }
        } else if (this.plateau[numCase] != this.joueur) {
            JOptionPane.showMessageDialog(this.frmTest, "Veillez s\u00e9lectionner un de vos pions", "Faute de jeu", 0);
        } else if (this.plateau[26] == this.joueur && numCase != 26) {
            JOptionPane.showMessageDialog(this.frmTest, "Vous devez sauvez votre pion de la maison des Eaux avec ce lancer", "Faute de jeu", 0);
        } else {
            int numJoueur = (this.joueur - 1) / -2;
            int result = numCase + this.des;
            switch (numCase) {
                case 29: {
                    int n = numJoueur;
                    this.remains[n] = this.remains[n] - 1;
                    this.plateau[numCase] = 0;
                    if (!this.changeJoueur()) break;
                    this.samePlayerShootAgain();
                    break;
                }
                case 28: {
                    if (this.des == 2) {
                        int n = numJoueur;
                        this.remains[n] = this.remains[n] - 1;
                        this.plateau[numCase] = 0;
                        this.changeJoueur();
                        break;
                    }
                    JOptionPane.showMessageDialog(this.frmTest, "Le seul moyen de bouger un pion dans la maison des deux juges est de faire un 2. Jouez un autre pion.", "Faute de jeu", 0);
                    break;
                }
                case 27: {
                    if (this.des == 3) {
                        int n = numJoueur;
                        this.remains[n] = this.remains[n] - 1;
                        this.plateau[numCase] = 0;
                        this.changeJoueur();
                        break;
                    }
                    JOptionPane.showMessageDialog(this.frmTest, "Le seul moyen de bouger un pion dans la maison des trois juges est de faire un 3. Jouez un autre pion.", "Faute de jeu", 0);
                    break;
                }
                case 26: {
                    int n = numJoueur;
                    this.remains[n] = this.remains[n] - 1;
                    this.plateau[numCase] = 0;
                    if (!this.changeJoueur()) break;
                    this.samePlayerShootAgain();
                    break;
                }
                case 25: {
                    if (this.des == 5) {
                        int n = numJoueur;
                        this.remains[n] = this.remains[n] - 1;
                        this.plateau[numCase] = 0;
                    } else {
                        if (this.plateau[result] == this.joueur) {
                            JOptionPane.showMessageDialog(this.frmTest, "Vous ne pouvez pas vous d\u00e9placer sur une de vos pi\u00e8ces", "Faute de jeu", 0);
                            return;
                        }
                        if (this.des == 1) {
                            this.des = 0;
                            this.plateau[numCase] = this.plateau[result];
                            this.plateau[result] = this.joueur;
                        } else {
                            this.plateau[numCase] = 0;
                            if (this.plateau[result] == -this.joueur) {
                                if (this.plateau[26] != 0) {
                                    this.plateau[25] = -this.joueur;
                                } else {
                                    this.plateau[26] = -this.joueur;
                                }
                            }
                            this.plateau[result] = this.joueur;
                        }
                    }
                    if (!this.changeJoueur()) break;
                    this.samePlayerShootAgain();
                    break;
                }
                default: {
                    if (result > 25) {
                        JOptionPane.showMessageDialog(this.frmTest, "Vous devez vous arr\u00eater sur la case aux miroirs avec un compte exact. Ce pion va trop loin, choisissez-en un autre.", "Faute de jeu", 0);
                        break;
                    }
                    if (this.plateau[result] == this.joueur) {
                        JOptionPane.showMessageDialog(this.frmTest, "Vous ne pouvez pas vous d\u00e9placer sur une de vos pi\u00e8ces", "Faute de jeu", 0);
                        break;
                    }
                    if (this.plateau[result] == -this.joueur && (result == 25 && this.plateau[24] == -this.joueur || this.plateau[result - 1] == -this.joueur || this.plateau[result + 1] == -this.joueur)) {
                        JOptionPane.showMessageDialog(this.frmTest, "Vous ne pouvez pas vous d\u00e9placer sur un pi\u00e8ce adverse prot\u00e9g\u00e9e", "Faute de jeu", 0);
                        break;
                    }
                    this.plateau[numCase] = this.plateau[result];
                    this.plateau[result] = this.joueur;
                    if (!this.changeJoueur()) break;
                    this.samePlayerShootAgain();
                }
            }
        }
    }

    private void samePlayerShootAgain() {
        this.joueur = -this.joueur;
        this.lblJoueurQuiJoue.setText(this.players[(1 - this.joueur) / 2]);
        this.buttons[26].setBackground(Color.yellow);
    }

    private boolean checkForward() {
        boolean canMove = false;
        if (this.des > 0) {
            if (this.plateau[26] == this.joueur && this.des == 4) {
                canMove = true;
                this.buttons[26].setBackground(this.hints.isSelected() ? Color.green : Color.yellow);
            } else {
                if (this.des == 3 && this.plateau[27] == this.joueur) {
                    canMove = true;
                    this.buttons[27].setBackground(this.hints.isSelected() ? Color.green : Color.orange);
                }
                if (this.des == 2 && this.plateau[28] == this.joueur) {
                    canMove = true;
                    this.buttons[28].setBackground(this.hints.isSelected() ? Color.green : Color.yellow);
                }
                if (this.plateau[29] == this.joueur) {
                    canMove = true;
                    this.buttons[29].setBackground(this.hints.isSelected() ? Color.green : Color.orange);
                }
                if (this.plateau[25] == this.joueur && (this.des == 5 || this.plateau[25 + this.des] != this.joueur)) {
                    canMove = true;
                    this.buttons[25].setBackground(this.hints.isSelected() ? Color.green : Color.orange);
                }
                int i = 0;
                while (i < 26 - this.des) {
                    int result = i + this.des;
                    if (this.plateau[i] == this.joueur && this.plateau[result] != this.joueur && (result != 25 || this.plateau[25] != -this.joueur || this.plateau[24] != -this.joueur) && (this.plateau[result] != -this.joueur || this.plateau[result - 1] != -this.joueur && this.plateau[result + 1] != -this.joueur)) {
                        canMove = true;
                        if (this.hints.isSelected()) {
                            this.buttons[i].setBackground(Color.green);
                        } else {
                            this.buttons[i].setBackground(i % 2 == 0 ? Color.yellow : Color.orange);
                        }
                    }
                    ++i;
                }
            }
        }
        return canMove;
    }

    private boolean checkBackward() {
        boolean canMove = false;
        if (this.des < 0) {
            int i = -this.des;
            while (i < 26) {
                int result = i + this.des;
                if (this.plateau[i] == this.joueur && this.plateau[result] != this.joueur && (result != 0 || this.plateau[0] != -this.joueur || this.plateau[1] != -this.joueur) && (this.plateau[result] != -this.joueur || this.plateau[result - 1] != -this.joueur && this.plateau[result + 1] != -this.joueur)) {
                    canMove = true;
                    if (this.hints.isSelected()) {
                        this.buttons[i].setBackground(Color.green);
                    } else {
                        this.buttons[i].setBackground(i % 2 == 0 ? Color.yellow : Color.orange);
                    }
                }
                ++i;
            }
        }
        return canMove;
    }
}

